<?php

namespace Bixo\Payroll\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SalaryResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('payroll/salary') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'slug' => $this->slug,
            'organization_id' => $this->organization_id,
            'employee_id' => $this->employee_id,
            'salary' => $this->salary,
            'commission_per' => $this->commission_per,
            'type' => $this->type,
            'date' => $this->date,
            'user_id' => $this->user_id,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param     \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    /**
     * Get the workflows for the resource.
     *
     * @return array
     */
    private function workflows()
    {
        $arr = [];
                $workflow = $this->resource->workflow();
        foreach ($workflow->transitions($this) as $key => $transition) {
            $name = $transition->getName();
            $arr[$key]['url'] = guard_url('payroll/salary/workflow/' . $this->getRouteKey() . '/' . $name);
            $arr[$key]['name'] = $name;
            $arr[$key]['key'] = $name;
            $arr[$key]['form'] = $workflow->form($transition);
            $arr[$key]['label'] = trans('payroll::salary.workflow.' . $name);
        }
                return $arr;

    }
    
    /**
     * Get the actions for the resource.
     *
     * @return array
     */
    private function actions()
    {

        $arr = [];
        
        return $arr;
    }
}
