<?php

namespace Bixo\Payroll\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Payroll\Events\AdjustmentAction as AdjustmentActionEvent;
use Bixo\Payroll\Notifications\AdjustmentAction as AdjustmentActionNotification;
use Litepie\Actions\Concerns\AsAction;

class AdjustmentAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the AdjustmentActionEvent.
     *
     * @param   AdjustmentActionEvent  $event
     * @return mixed
     */
    public function handle(AdjustmentActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $adjustment.
     *
     * @param   AdjustmentActionEvent  $event
     * @return void
     */
    public function create(AdjustmentActionEvent $event)
    {
        $client = $event->adjustment->client;
        Notification::send($client, new AdjustmentActionNotification($event));
    }

    /**
     * Handle the AdjustmentActionEvent as a listener.
     *
     * @param   AdjustmentActionEvent  $event
     * @return mixed
     */
    public function asListener(AdjustmentActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   AdjustmentActionEvent  $event
     * @return bool
     */
    private function isAllowed(AdjustmentActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
