<?php

namespace Bixo\Payroll\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Payroll\Events\CommissionAction as CommissionActionEvent;
use Bixo\Payroll\Notifications\CommissionAction as CommissionActionNotification;
use Litepie\Actions\Concerns\AsAction;

class CommissionAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the CommissionActionEvent.
     *
     * @param   CommissionActionEvent  $event
     * @return mixed
     */
    public function handle(CommissionActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $commission.
     *
     * @param   CommissionActionEvent  $event
     * @return void
     */
    public function create(CommissionActionEvent $event)
    {
        $client = $event->commission->client;
        Notification::send($client, new CommissionActionNotification($event));
    }

    /**
     * Handle the CommissionActionEvent as a listener.
     *
     * @param   CommissionActionEvent  $event
     * @return mixed
     */
    public function asListener(CommissionActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   CommissionActionEvent  $event
     * @return bool
     */
    private function isAllowed(CommissionActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
