<?php

namespace Bixo\Payroll\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Payroll\Events\SalaryAction as SalaryActionEvent;
use Bixo\Payroll\Notifications\SalaryAction as SalaryActionNotification;
use Litepie\Actions\Concerns\AsAction;

class SalaryAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the SalaryActionEvent.
     *
     * @param   SalaryActionEvent  $event
     * @return mixed
     */
    public function handle(SalaryActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $salary.
     *
     * @param   SalaryActionEvent  $event
     * @return void
     */
    public function create(SalaryActionEvent $event)
    {
        $client = $event->salary->client;
        Notification::send($client, new SalaryActionNotification($event));
    }

    /**
     * Handle the SalaryActionEvent as a listener.
     *
     * @param   SalaryActionEvent  $event
     * @return mixed
     */
    public function asListener(SalaryActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   SalaryActionEvent  $event
     * @return bool
     */
    private function isAllowed(SalaryActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
