<?php

namespace Bixo\Payroll\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Payroll\Events\SlabAction as SlabActionEvent;
use Bixo\Payroll\Notifications\SlabAction as SlabActionNotification;
use Litepie\Actions\Concerns\AsAction;

class SlabAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the SlabActionEvent.
     *
     * @param   SlabActionEvent  $event
     * @return mixed
     */
    public function handle(SlabActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $slab.
     *
     * @param   SlabActionEvent  $event
     * @return void
     */
    public function create(SlabActionEvent $event)
    {
        $client = $event->slab->client;
        Notification::send($client, new SlabActionNotification($event));
    }

    /**
     * Handle the SlabActionEvent as a listener.
     *
     * @param   SlabActionEvent  $event
     * @return mixed
     */
    public function asListener(SlabActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   SlabActionEvent  $event
     * @return bool
     */
    private function isAllowed(SlabActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
