<?php

namespace Bixo\Payroll\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Payroll\Models\Adjustment;

class AdjustmentPolicy
{

    use AdjustmentWorkflow;

    /**
     * Determine if the given user can view the adjustment.
     *
     * @param Authenticatable $user
     * @param Adjustment $adjustment
     *
     * @return bool
     */
    public function view(Authenticatable $user, Adjustment $adjustment)
    {
        if ($authUser->canDo('payroll.adjustment.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $adjustment->is_owner;
    }

    /**
     * Determine if the given user can create a adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('payroll.adjustment.create');
    }

    /**
     * Determine if the given user can update the given adjustment.
     *
     * @param Authenticatable $user
     * @param Adjustment $adjustment
     *
     * @return bool
     */
    public function update(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.edit') && $user->isAdmin()) {
            return true;
        }

        return $adjustment->is_owner;
    }

    /**
     * Determine if the given user can delete the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Adjustment $adjustment)
    {
        return $adjustment->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
