<?php

namespace Bixo\Payroll\Policies;

use Bixo\Payroll\Models\Adjustment;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait AdjustmentWorkflow
{

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given adjustment.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Adjustment $adjustment)
    {
        if ($user->canDo('payroll.adjustment.reject')) {
            return true;
        }

        return false;
    }

}
