<?php

namespace Bixo\Payroll\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Payroll\Models\Commission;

class CommissionPolicy
{

    use CommissionWorkflow;

    /**
     * Determine if the given user can view the commission.
     *
     * @param Authenticatable $user
     * @param Commission $commission
     *
     * @return bool
     */
    public function view(Authenticatable $user, Commission $commission)
    {
        if ($authUser->canDo('payroll.commission.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $commission->is_owner;
    }

    /**
     * Determine if the given user can create a commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('payroll.commission.create');
    }

    /**
     * Determine if the given user can update the given commission.
     *
     * @param Authenticatable $user
     * @param Commission $commission
     *
     * @return bool
     */
    public function update(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.edit') && $user->isAdmin()) {
            return true;
        }

        return $commission->is_owner;
    }

    /**
     * Determine if the given user can delete the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Commission $commission)
    {
        return $commission->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
