<?php

namespace Bixo\Payroll\Policies;

use Bixo\Payroll\Models\Commission;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait CommissionWorkflow
{

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given commission.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Commission $commission)
    {
        if ($user->canDo('payroll.commission.reject')) {
            return true;
        }

        return false;
    }

}
