<?php

namespace Bixo\Payroll\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Payroll\Models\Payroll;

class PayrollPolicy
{

    use PayrollWorkflow;

    /**
     * Determine if the given user can view the payroll.
     *
     * @param Authenticatable $user
     * @param Payroll $payroll
     *
     * @return bool
     */
    public function view(Authenticatable $user, Payroll $payroll)
    {
        if ($authUser->canDo('payroll.payroll.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $payroll->is_owner;
    }

    /**
     * Determine if the given user can create a payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('payroll.payroll.create');
    }

    /**
     * Determine if the given user can update the given payroll.
     *
     * @param Authenticatable $user
     * @param Payroll $payroll
     *
     * @return bool
     */
    public function update(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.edit') && $user->isAdmin()) {
            return true;
        }

        return $payroll->is_owner;
    }

    /**
     * Determine if the given user can delete the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Payroll $payroll)
    {
        return $payroll->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
