<?php

namespace Bixo\Payroll\Policies;

use Bixo\Payroll\Models\Payroll;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait PayrollWorkflow
{

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given payroll.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Payroll $payroll)
    {
        if ($user->canDo('payroll.payroll.reject')) {
            return true;
        }

        return false;
    }

}
