<?php

namespace Bixo\Payroll\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Payroll\Models\Salary;

class SalaryPolicy
{

    use SalaryWorkflow;

    /**
     * Determine if the given user can view the salary.
     *
     * @param Authenticatable $user
     * @param Salary $salary
     *
     * @return bool
     */
    public function view(Authenticatable $user, Salary $salary)
    {
        if ($authUser->canDo('payroll.salary.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $salary->is_owner;
    }

    /**
     * Determine if the given user can create a salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('payroll.salary.create');
    }

    /**
     * Determine if the given user can update the given salary.
     *
     * @param Authenticatable $user
     * @param Salary $salary
     *
     * @return bool
     */
    public function update(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.edit') && $user->isAdmin()) {
            return true;
        }

        return $salary->is_owner;
    }

    /**
     * Determine if the given user can delete the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Salary $salary)
    {
        return $salary->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
