<?php

namespace Bixo\Payroll\Policies;

use Bixo\Payroll\Models\Salary;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait SalaryWorkflow
{

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given salary.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Salary $salary)
    {
        if ($user->canDo('payroll.salary.reject')) {
            return true;
        }

        return false;
    }

}
