<?php

namespace Bixo\Payroll\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Payroll\Models\Slab;

class SlabPolicy
{

    use SlabWorkflow;

    /**
     * Determine if the given user can view the slab.
     *
     * @param Authenticatable $user
     * @param Slab $slab
     *
     * @return bool
     */
    public function view(Authenticatable $user, Slab $slab)
    {
        if ($authUser->canDo('payroll.slab.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $slab->is_owner;
    }

    /**
     * Determine if the given user can create a slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('payroll.slab.create');
    }

    /**
     * Determine if the given user can update the given slab.
     *
     * @param Authenticatable $user
     * @param Slab $slab
     *
     * @return bool
     */
    public function update(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.edit') && $user->isAdmin()) {
            return true;
        }

        return $slab->is_owner;
    }

    /**
     * Determine if the given user can delete the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Slab $slab)
    {
        return $slab->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
