<?php

namespace Bixo\Payroll\Policies;

use Bixo\Payroll\Models\Slab;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait SlabWorkflow
{

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given slab.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Slab $slab)
    {
        if ($user->canDo('payroll.slab.reject')) {
            return true;
        }

        return false;
    }

}
