<?php

namespace Bixo\Payroll\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Payroll policy
        \Bixo\Payroll\Models\Payroll::class 
        => \Bixo\Payroll\Policies\PayrollPolicy::class,// Bind Commission policy
        \Bixo\Payroll\Models\Commission::class 
        => \Bixo\Payroll\Policies\CommissionPolicy::class,// Bind Adjustment policy
        \Bixo\Payroll\Models\Adjustment::class 
        => \Bixo\Payroll\Policies\AdjustmentPolicy::class,// Bind Salary policy
        \Bixo\Payroll\Models\Salary::class 
        => \Bixo\Payroll\Policies\SalaryPolicy::class,// Bind Slab policy
        \Bixo\Payroll\Models\Slab::class 
        => \Bixo\Payroll\Policies\SlabPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
