<?php

namespace Bixo\Payroll\Providers;

use Illuminate\Support\ServiceProvider;
use Bixo\Payroll\Payrolls;

class PayrollServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'payroll');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'payroll');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();

        $this->app->register(\Bixo\Payroll\Providers\AuthServiceProvider::class);
        $this->app->register(\Bixo\Payroll\Providers\RouteServiceProvider::class);
        $this->app->register(\Bixo\Payroll\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('bixo.payroll', function($app)
        {
            return $this->app->make(Payroll::class);
        });
    }

    /**
     * Merges user's and payroll's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.payroll'
        );
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/payroll.php', 'bixo.payroll.payroll'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/commission.php', 'bixo.payroll.commission'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/adjustment.php', 'bixo.payroll.adjustment'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/salary.php', 'bixo.payroll.salary'
        );
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/slab.php', 'bixo.payroll.slab'
        );
    }


    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.payroll'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('bixo/payroll')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/payroll')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/payroll')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
