<?php

namespace Bixo\Payroll\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Bixo\Payroll\Models\Payroll;
use Bixo\Payroll\Models\Commission;
use Bixo\Payroll\Models\Adjustment;
use Bixo\Payroll\Models\Salary;
use Bixo\Payroll\Models\Slab;

use Request;
use Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to the controller routes in your routes file.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Bixo\Payroll\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param   \Illuminate\Routing\Router  $router
     * @return void
     */
    public function boot()
    {
        parent::boot();

        if (Request::is('*/payroll/payroll/*')) {
            Route::bind('payroll', function ($payroll) {
                return Payroll::findorNew($payroll);
            });
        }
        if (Request::is('*/payroll/commission/*')) {
            Route::bind('commission', function ($commission) {
                return Commission::findorNew($commission);
            });
        }
        if (Request::is('*/payroll/adjustment/*')) {
            Route::bind('adjustment', function ($adjustment) {
                return Adjustment::findorNew($adjustment);
            });
        }
        if (Request::is('*/payroll/salary/*')) {
            Route::bind('salary', function ($salary) {
                return Salary::findorNew($salary);
            });
        }
        if (Request::is('*/payroll/slab/*')) {
            Route::bind('slab', function ($slab) {
                return Slab::findorNew($slab);
            });
        }

    }

    /**
     * Define the routes for the package.
     *
     * @return void
     */
    public function map()
    {
        $this->mapWebRoutes();

        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the package.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {   
        Route::group([
            'middleware' => 'web',
            'namespace'  => $this->namespace,
        ], function ($router) {
            require (__DIR__ . '/../../routes/web.php');
        });
    }

    /**
     * Define the "api" routes for the package.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::group([
            'middleware' => 'api',
            'namespace'  => $this->namespace,
            'prefix'     => 'api',
        ], function ($router) {
            require (__DIR__ . '/../../routes/api.php');
        });
    }

}
