<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'quote',

    /*
     * Modules.
     */
    'modules'   => ['quotes'],

    
    'quotes'       => [
        'model' => [
            'model'                 => \Litecms\Quote\Models\Quotes::class,
            'table'                 => 'quotes',
            'presenter'             => \Litecms\Quote\Repositories\Presenter\QuotesPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name'],
            'translatables'         => [],
            'upload_folder'         => 'quote/quotes',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'Quote',
            'module'    => 'Quotes',
        ],

    ],
];
