# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/litecms/quote/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/litecms/quote/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Litecms\\Quote\\": "packages/litecms/quote/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Litecms\Quote\Providers\QuoteServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Quote'  => Litecms\Quote\Facades\Quote::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Litecms\\QuoteTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/quote/{modulename}

**User**

    http://path-to-route-folder/user/quote/{modulename}

**Public**

    http://path-to-route-folder/quotes


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/quote/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/quote/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/quote/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/quote/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/quote/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/quote/{modulename}/{slug}
    METHOD: GET