Lavalite package that provides quote management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `litecms/quote`.

    "litecms/quote": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Litecms\Quote\Providers\QuoteServiceProvider::class,

And also add it to alias

    'Quote'  => Litecms\Quote\Facades\Quote::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Litecms\\QuoteTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\Quote\Providers\QuoteServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/quote/{modulename}

**User**

    http://path-to-route-folder/user/quote/{modulename}

**Public**

    http://path-to-route-folder/quotes


### API endpoints

**List**

    http://path-to-route-folder/api/user/quote/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/quote/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/quote/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/quote/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/quote/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/quote/{modulename}/{slug}
    METHOD: GET