<?php

// API routes  for quotes
Route::prefix('{guard}/quote')->group(function () {
    Route::get('quotes/form/{element}', 'QuotesAPIController@form');
    Route::resource('quotes', 'QuotesAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for quotes
            Route::prefix('{guard}/quote')->group(function () {
                Route::get('quotes/form/{element}', 'QuotesAPIController@form');
                Route::apiResource('quotes', 'QuotesAPIController');
            });
            // Public routes for quotes
            Route::get('quote/Quotes', 'QuotesPublicController@getQuotes');
        }
    );
}

