<?php

// web routes  for quotes
Route::prefix('{guard}/quote')->group(function () {
    Route::resource('quotes', 'QuotesResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'QuotesResourceController');
            });
            // Public routes for pages
            Route::get('quotes/', 'QuotesPublicController@index');
            Route::get('quotes/{slug?}', 'QuotesPublicController@show');
        }
    );
}

