<?php

namespace Litecms\Quote\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Quote\Models\Quotes;

class QuotesPolicy
{

    /**
     * Determine if the given user can view the quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function view(UserPolicy $user, Quotes $quotes)
    {
        if ($user->canDo('quote.quotes.view') && $user->isAdmin()) {
            return true;
        }

        return $quotes->user_id == user_id() && $quotes->user_type == user_type();
    }

    /**
     * Determine if the given user can create a quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('quote.quotes.create');
    }

    /**
     * Determine if the given user can update the given quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function update(UserPolicy $user, Quotes $quotes)
    {
        if ($user->canDo('quote.quotes.edit') && $user->isAdmin()) {
            return true;
        }

        return $quotes->user_id == user_id() && $quotes->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Quotes $quotes)
    {
        return $quotes->user_id == user_id() && $quotes->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Quotes $quotes)
    {
        if ($user->canDo('quote.quotes.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given quotes.
     *
     * @param UserPolicy $user
     * @param Quotes $quotes
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Quotes $quotes)
    {
        if ($user->canDo('quote.quotes.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
