<?php

namespace Litecms\Quote;

use User;

class Quote
{
    /**
     * $quotes object.
     */
    protected $quotes;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\Quote\Interfaces\QuotesRepositoryInterface $quotes)
    {
        $this->quotes = $quotes;
    }

    /**
     * Returns count of quote.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.quotes.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->quotes->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\QuotesUserCriteria());
        }

        $quotes = $this->quotes->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('quote::' . $view, compact('quotes'))->render();
    }
}
