<?php

namespace Litecms\Quote\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class QuotesTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Quote\Models\Quotes $quotes)
    {
        return [
            'id'                => $quotes->getRouteKey(),
            'key'               => [
                'public'    => $quotes->getPublicKey(),
                'route'     => $quotes->getRouteKey(),
            ], 
            'name'              => $quotes->name,
            'url'               => [
                'public'    => trans_url('quote/'.$quotes->getPublicKey()),
                'user'      => guard_url('quote/quotes/'.$quotes->getRouteKey()),
            ], 
            'status'            => trans('app.'.$quotes->status),
            'created_at'        => format_date($quotes->created_at),
            'updated_at'        => format_date($quotes->updated_at),
        ];
    }
}