<?php

namespace Litecms\RepresentativeCommission\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\RepresentativeCommission\Http\Requests\RepresentativeCommissionRequest;
use Litecms\RepresentativeCommission\Interfaces\RepresentativeCommissionRepositoryInterface;
use Litecms\RepresentativeCommission\Models\RepresentativeCommission;

/**
 * Resource controller class for representative_commission.
 */
class RepresentativeCommissionResourceController extends BaseController
{

    /**
     * Initialize representative_commission resource controller.
     *
     * @param type RepresentativeCommissionRepositoryInterface $representative_commission
     *
     * @return null
     */
    public function __construct(RepresentativeCommissionRepositoryInterface $representative_commission)
    {
        parent::__construct();
        $this->repository = $representative_commission;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\RepresentativeCommission\Repositories\Criteria\RepresentativeCommissionResourceCriteria::class);
    }

    /**
     * Display a list of representative_commission.
     *
     * @return Response
     */
    public function index(RepresentativeCommissionRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\RepresentativeCommission\Repositories\Presenter\RepresentativeCommissionPresenter::class)
                ->$function();
        }

        $representative_commissions = $this->repository->paginate();

        return $this->response->title(trans('representative_commission::representative_commission.names'))
            ->view('representative_commission::representative_commission.index', true)
            ->data(compact('representative_commissions'))
            ->output();
    }

    /**
     * Display representative_commission.
     *
     * @param Request $request
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function show(RepresentativeCommissionRequest $request, RepresentativeCommission $representative_commission)
    {

        if ($representative_commission->exists) {
            $view = 'representative_commission::representative_commission.show';
        } else {
            $view = 'representative_commission::representative_commission.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('representative_commission::representative_commission.name'))
            ->data(compact('representative_commission'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new representative_commission.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(RepresentativeCommissionRequest $request)
    {

        $representative_commission = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('representative_commission::representative_commission.name')) 
            ->view('representative_commission::representative_commission.create', true) 
            ->data(compact('representative_commission'))
            ->output();
    }

    /**
     * Create new representative_commission.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(RepresentativeCommissionRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $representative_commission                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('representative_commission::representative_commission.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('representative_commission/representative_commission/' . $representative_commission->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/representative_commission/representative_commission'))
                ->redirect();
        }

    }

    /**
     * Show representative_commission for editing.
     *
     * @param Request $request
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function edit(RepresentativeCommissionRequest $request, RepresentativeCommission $representative_commission)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('representative_commission::representative_commission.name'))
            ->view('representative_commission::representative_commission.edit', true)
            ->data(compact('representative_commission'))
            ->output();
    }

    /**
     * Update the representative_commission.
     *
     * @param Request $request
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function update(RepresentativeCommissionRequest $request, RepresentativeCommission $representative_commission)
    {
        try {
            $attributes = $request->all();

            $representative_commission->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('representative_commission::representative_commission.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('representative_commission/representative_commission/' . $representative_commission->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('representative_commission/representative_commission/' . $representative_commission->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the representative_commission.
     *
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function destroy(RepresentativeCommissionRequest $request, RepresentativeCommission $representative_commission)
    {
        try {

            $representative_commission->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('representative_commission::representative_commission.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('representative_commission/representative_commission/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('representative_commission/representative_commission/' . $representative_commission->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple representative_commission.
     *
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function delete(RepresentativeCommissionRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('representative_commission::representative_commission.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('representative_commission/representative_commission'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/representative_commission/representative_commission'))
                ->redirect();
        }

    }

    /**
     * Restore deleted representative_commissions.
     *
     * @param Model   $representative_commission
     *
     * @return Response
     */
    public function restore(RepresentativeCommissionRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('representative_commission::representative_commission.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/representative_commission/representative_commission'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/representative_commission/representative_commission/'))
                ->redirect();
        }

    }

}
