<?php

namespace Litecms\RepresentativeCommission\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\RepresentativeCommission\Models\RepresentativeCommission;

class RepresentativeCommissionPolicy
{

    /**
     * Determine if the given user can view the representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function view(UserPolicy $user, RepresentativeCommission $representative_commission)
    {
        if ($user->canDo('representative_commission.representative_commission.view') && $user->isAdmin()) {
            return true;
        }

        return $representative_commission->user_id == user_id() && $representative_commission->user_type == user_type();
    }

    /**
     * Determine if the given user can create a representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('representative_commission.representative_commission.create');
    }

    /**
     * Determine if the given user can update the given representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function update(UserPolicy $user, RepresentativeCommission $representative_commission)
    {
        if ($user->canDo('representative_commission.representative_commission.edit') && $user->isAdmin()) {
            return true;
        }

        return $representative_commission->user_id == user_id() && $representative_commission->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, RepresentativeCommission $representative_commission)
    {
        return $representative_commission->user_id == user_id() && $representative_commission->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function verify(UserPolicy $user, RepresentativeCommission $representative_commission)
    {
        if ($user->canDo('representative_commission.representative_commission.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given representative_commission.
     *
     * @param UserPolicy $user
     * @param RepresentativeCommission $representative_commission
     *
     * @return bool
     */
    public function approve(UserPolicy $user, RepresentativeCommission $representative_commission)
    {
        if ($user->canDo('representative_commission.representative_commission.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
