<?php

namespace Litecms\RepresentativeCommission\Providers;

use Illuminate\Support\ServiceProvider;

class RepresentativeCommissionServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'representative_commission');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'representative_commission');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.representative_commission', function ($app) {
            return $this->app->make('Litecms\RepresentativeCommission\RepresentativeCommission');
        });

                // Bind RepresentativeCommission to repository
        $this->app->bind(
            'Litecms\RepresentativeCommission\Interfaces\RepresentativeCommissionRepositoryInterface',
            \Litecms\RepresentativeCommission\Repositories\Eloquent\RepresentativeCommissionRepository::class
        );

        $this->app->register(\Litecms\RepresentativeCommission\Providers\AuthServiceProvider::class);
                $this->app->register(\Litecms\RepresentativeCommission\Providers\EventServiceProvider::class);
        
        $this->app->register(\Litecms\RepresentativeCommission\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.representative_commission'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/representative_commission.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/representative_commission')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/representative_commission')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
