<?php

namespace Litecms\RepresentativeCommission\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class RepresentativeCommissionTransformer extends TransformerAbstract
{
    public function transform(\Litecms\RepresentativeCommission\Models\RepresentativeCommission $representative_commission)
    {
        return [
            'id'                => $representative_commission->getRouteKey(),
            'key'               => [
                'public'    => $representative_commission->getPublicKey(),
                'route'     => $representative_commission->getRouteKey(),
            ], 
            'level_1'           => $representative_commission->level_1,
            'level_2'           => $representative_commission->level_2,
            'level_3'           => $representative_commission->level_3,
            'url'               => [
                'public'    => trans_url('representative_commission/'.$representative_commission->getPublicKey()),
                'user'      => guard_url('representative_commission/representative_commission/'.$representative_commission->getRouteKey()),
            ], 
            'status'            => trans('app.'.$representative_commission->status),
            'created_at'        => format_date($representative_commission->created_at),
            'updated_at'        => format_date($representative_commission->updated_at),
        ];
    }
}