<?php

namespace Litecms\RepresentativeCommission;

use User;

class RepresentativeCommission
{
    /**
     * $representative_commission object.
     */
    protected $representative_commission;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\RepresentativeCommission\Interfaces\RepresentativeCommissionRepositoryInterface $representative_commission)
    {
        $this->representative_commission = $representative_commission;
    }

    /**
     * Returns count of representative_commission.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.representative_commission.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->representative_commission->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\RepresentativeCommissionUserCriteria());
        }

        $representative_commission = $this->representative_commission->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('representative_commission::' . $view, compact('representative_commission'))->render();
    }
}
