<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'shopping',

    /*
     * Package.
     */
    'package'   => 'status',

    /*
     * Modules.
     */
    'modules'   => ['status'],

    
    'status'       => [
        'model' => [
            'model'                 => \Shopping\Status\Models\Status::class,
            'table'                 => 'statuses',
            'presenter'             => \Shopping\Status\Repositories\Presenter\StatusPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'slug',  'name',  'order',  'details',  'deleted_at',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'status/status',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Shopping',
            'package'   => 'Status',
            'module'    => 'Status',
        ],

    ],
];
