<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: statuses
         */
        Schema::create('statuses', function ($table) {
            $table->increments('id');
            $table->string('slug', 200)->nullable();
            $table->string('name', 255)->nullable();
            $table->integer('order')->nullable();
            $table->text('details')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('statuses');
    }
}
