<?php

namespace Shopping\Status\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class StatusTransformer extends TransformerAbstract
{
    public function transform(\Shopping\Status\Models\Status $status)
    {
        return [
            'id'                => $status->getRouteKey(),
            'key'               => [
                'public'    => $status->getPublicKey(),
                'route'     => $status->getRouteKey(),
            ], 
            'id'                => $status->id,
            'slug'              => $status->slug,
            'name'              => $status->name,
            'order'             => $status->order,
            'details'           => $status->details,
            'deleted_at'        => $status->deleted_at,
            'created_at'        => $status->created_at,
            'updated_at'        => $status->updated_at,
            'url'               => [
                'public'    => trans_url('status/'.$status->getPublicKey()),
                'user'      => guard_url('status/status/'.$status->getRouteKey()),
            ], 
            'status'            => trans('app.'.$status->status),
            'created_at'        => format_date($status->created_at),
            'updated_at'        => format_date($status->updated_at),
        ];
    }
}