<?php

namespace Shopping\Status;

use User;

class Status
{
    /**
     * $status object.
     */
    protected $status;

    /**
     * Constructor.
     */
    public function __construct(\Shopping\Status\Interfaces\StatusRepositoryInterface $status)
    {
        $this->status = $status;
    }

    /**
     * Returns count of status.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.status.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->status->pushCriteria(new \Litepie\Shopping\Repositories\Criteria\StatusUserCriteria());
        }

        $status = $this->status->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('status::' . $view, compact('status'))->render();
    }
}
