# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/testimonials/testimonial/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Testimonials\\Testimonial\\": "packages/testimonials/testimonial/src",
            "Testimonials\\Testimonial\\Seeders\\": "packages/testimonials/testimonial/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Testimonials\Testimonial\Providers\TestimonialServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Testimonial'  => Testimonials\Testimonial\Facades\Testimonial::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Testimonials\\Testimonial\\Seeders\\TestimonialTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Testimonials\Testimonial\Providers\TestimonialServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/testimonial/{modulename}

**User**

    http://path-to-route-folder/user/testimonial/{modulename}

**Public**

    http://path-to-route-folder/testimonials


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/testimonial/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/testimonial/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/testimonial/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/testimonial/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/testimonial/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/testimonial/{modulename}/{slug}
    METHOD: GET