# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/service/service/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Service\\Service\\": "packages/service/service/src",
            "Service\\Service\\Seeders\\": "packages/service/service/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Service\Service\Providers\ServiceServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Service'  => Service\Service\Facades\Service::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Service\\Service\\Seeders\\ServiceTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/service/{modulename}

**User**

    http://path-to-route-folder/user/service/{modulename}

**Public**

    http://path-to-route-folder/services


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/service/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/service/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/service/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/service/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/service/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/service/{modulename}/{slug}
    METHOD: GET