Lavalite package that provides service management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `service/service`.

    "service/service": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Service\Service\Providers\ServiceServiceProvider::class,

And also add it to alias

    'Service'  => Service\Service\Facades\Service::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Service\\Service\\Seeders\\ServiceTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Service\Service\Providers\ServiceServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/service/{modulename}

**User**

    http://path-to-route-folder/user/service/{modulename}

**Public**

    http://path-to-route-folder/services


### API endpoints

**List**

    http://path-to-route-folder/api/user/service/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/service/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/service/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/service/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/service/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/service/{modulename}/{slug}
    METHOD: GET